<!DOCTYPE html>
<html>
<head>
    <title>Database Graph</title>
    <!-- Include Chart.js library -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <div style="width: 80%; margin: 0 auto;">
        <canvas id="myChart"></canvas>
    </div>

    <script>
        // Retrieve data from PHP
        var data = <?php echo $dataJSON; ?>;
        
        // Get the canvas element
        var ctx = document.getElementById('myChart').getContext('2d');

        // Create a chart
        var myChart = new Chart(ctx, {
            type: 'bar', // Change to 'line', 'pie', etc., as needed
            data: {
                labels: data.months,
                datasets: [{
                    label: 'Revenue',
                    data: data.revenues,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>
